<main class="max-w-6xl p-4 mx-auto lg:p-8 lg:px-0 md:mt-2">
    <h2 class="text-4xl font-bold">Mis compras</h2>
    @if (count($shopping) > 0)
        @foreach ($shopping as $row)
            <div class="p-8 mt-4 border-2 border-gray-200 rounded-lg shadow-xl">
                <p class="text-lg font-semibold">Pedido #{{ $row->id }}</p>
                <p class="text-lg font-semibold">Ordenado {{ date('d-m-Y h:i A', strtotime($row->created_at)) }}</p>
                @if ($row->status_id == 12)
                    <p
                        class="px-4 py-2 my-2 text-lg font-bold text-white rounded-lg bg-orange-600/70 w-fit animate-pulse">
                        Validando costo de Envío
                    </p>
                @endif
                <p class="text-lg font-semibold">Estatus</p>
                <ol class="flex items-center justify-center py-2 pl-2 mx-auto">
                    @if (
                        $row->status_id == 10 ||
                            $row->status_id == 12 ||
                            $row->status_id == 15 ||
                            $row->status_id == 16 ||
                            $row->status_id == 24)
                        <li class="relative w-full mb-4">
                            <div class="flex items-center justify-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-gray-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    {{ $row->status->name }}
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-gray-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-white size-3">
                                        <path fill-rule="evenodd"
                                            d="M5.47 5.47a.75.75 0 0 1 1.06 0L12 10.94l5.47-5.47a.75.75 0 1 1 1.06 1.06L13.06 12l5.47 5.47a.75.75 0 1 1-1.06 1.06L12 13.06l-5.47 5.47a.75.75 0 0 1-1.06-1.06L10.94 12 5.47 6.53a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-gray-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Enviado
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-gray-500 rounded-full ring-0 ring-white dark:bg-gray-700 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-white size-3">
                                        <path fill-rule="evenodd"
                                            d="M5.47 5.47a.75.75 0 0 1 1.06 0L12 10.94l5.47-5.47a.75.75 0 1 1 1.06 1.06L13.06 12l5.47 5.47a.75.75 0 1 1-1.06 1.06L12 13.06l-5.47 5.47a.75.75 0 0 1-1.06-1.06L10.94 12 5.47 6.53a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Finalizado</h3>
                            </div>
                        </li>
                    @elseif($row->status_id == 11)
                        <span class="inline-flex gap-2 px-2 py-1 text-xs text-white bg-red-500 rounded-lg sm:text-sm">
                            {{ $row->status->name }}
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-4 sm:size-6">
                                <path fill-rule="evenodd"
                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    @elseif($row->status_id == 13)
                        <span class="inline-flex gap-2 px-2 py-1 text-xs text-white bg-gray-400 rounded-lg sm:text-sm">
                            {{ $row->status->name }}
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-4 sm:size-6">
                                <path fill-rule="evenodd"
                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25ZM12.75 6a.75.75 0 0 0-1.5 0v6c0 .414.336.75.75.75h4.5a.75.75 0 0 0 0-1.5h-3.75V6Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    @elseif($row->status_id == 14)
                        <span class="inline-flex gap-2 px-2 py-1 text-xs text-white bg-red-500 rounded-lg sm:text-sm">
                            {{ $row->status->name }}
                            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                class="size-4 sm:size-6">
                                <path fill-rule="evenodd"
                                    d="M12 2.25c-5.385 0-9.75 4.365-9.75 9.75s4.365 9.75 9.75 9.75 9.75-4.365 9.75-9.75S17.385 2.25 12 2.25Zm-1.72 6.97a.75.75 0 1 0-1.06 1.06L10.94 12l-1.72 1.72a.75.75 0 1 0 1.06 1.06L12 13.06l1.72 1.72a.75.75 0 1 0 1.06-1.06L13.06 12l1.72-1.72a.75.75 0 1 0-1.06-1.06L12 10.94l-1.72-1.72Z"
                                    clip-rule="evenodd" />
                            </svg>
                        </span>
                    @elseif($row->status_id == 17)
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-green-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Pagado
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-gray-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Enviado
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-gray-500 rounded-full ring-0 ring-white dark:bg-gray-700 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                                        class="text-white size-3">
                                        <path fill-rule="evenodd"
                                            d="M5.47 5.47a.75.75 0 0 1 1.06 0L12 10.94l5.47-5.47a.75.75 0 1 1 1.06 1.06L13.06 12l5.47 5.47a.75.75 0 1 1-1.06 1.06L12 13.06l-5.47 5.47a.75.75 0 0 1-1.06-1.06L10.94 12 5.47 6.53a.75.75 0 0 1 0-1.06Z"
                                            clip-rule="evenodd" />
                                    </svg>
                                </div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Finalizado</h3>
                            </div>
                        </li>
                    @elseif($row->status_id == 18)
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-green-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Pagado
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-blue-900 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                                <div class="flex w-full bg-green-200 h-0.5 dark:bg-gray-700"></div>
                            </div>
                            <div class="mt-2">
                                <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                    Enviado
                                </h3>
                            </div>
                        </li>
                        <li class="relative w-full mb-4">
                            <div class="flex items-center">
                                <div
                                    class="z-10 flex items-center justify-center w-6 h-6 bg-green-500 rounded-full ring-0 ring-white dark:bg-gray-700 sm:ring-8 dark:ring-gray-900 shrink-0">
                                    <svg class="w-2.5 h-2.5 text-blue-100 dark:text-blue-300" aria-hidden="true"
                                        xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 16 12">
                                        <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                            stroke-width="2" d="M1 5.917 5.724 10.5 15 1.5" />
                                    </svg>
                                </div>
                            </div>
                            <h3 class="text-xs font-medium text-gray-900 dark:text-white sm:text-sm md:text-lg">
                                Finalizado</h3>
                        </li>
                    @endif
                </ol>
                @if (!is_null($row->guide_one) || !is_null($row->guide_two))
                    <div class="flex flex-col gap-1 p-3 border border-gray-200 rounded-lg">
                        @if (!is_null($row->guide_one))
                            <p class="text-lg">Puede visitar su guía de rastreo haciendo click al enlace</p>
                            <a class="text-xl font-semibold underline transition-all duration-300 hover:text-blue-500"
                                target="_blank"
                                href="https://www.dhl.com/global-en/home/tracking.html?tracking-id={{ $row->guide_one }}">
                                {{ $row->guide_one }}
                            </a>
                        @endif

                        @if (!is_null($row->guide_two))
                            •Guía de rastreo 2: <span class=" font-roboto">
                                <a class="text-xl underline transition-all duration-300 hover:text-blue-500"
                                    target="_blank"
                                    href="https://www.dhl.com/global-en/home/tracking.html?tracking-id={{ $row->guide_two }}">
                                    {{ $row->guide_two }}
                                </a>
                            </span>
                        @endif
                    </div>
                @endif
                @if ($row->invoice == 1)
                    <div x-data="{ open: false }" class="flex flex-col gap-1 p-4 border-b-2 border-gray-300">
                        <h3 @click="open = !open"
                            class="text-xl lg:text-2xl text-[#1d5394] font-semibold leading-none tracking-tight whitespace-nowrap cursor-pointer flex items-center justify-between">
                            Datos de facturación
                            <svg :class="open ? 'rotate-180' : ''" class="w-5 h-5 transition-transform"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="2" stroke="currentColor">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                            </svg>
                        </h3>

                        <div x-show="open" x-collapse class="flex flex-col gap-2 text-sm">
                            <span class="inline-flex items-center font-medium text-principalhover">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round" class="mr-2">
                                    <path d="M19 21v-2a4 4 0 0 0-4-4H9a4 4 0 0 0-4 4v2"></path>
                                    <circle cx="12" cy="7" r="4"></circle>
                                </svg>
                                Nombre
                            </span>
                            {{ $row->data_invoice->full_name }}

                            <span class="inline-flex items-center font-medium text-principalhover">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.07 1.916l-7.5 4.615a2.25 2.25 0 0 1-2.36 0L3.32 8.91a2.25 2.25 0 0 1-1.07-1.916V6.75" />
                                </svg>
                                Correo
                            </span>
                            {{ $row->data_invoice->email }}

                            <span class="inline-flex items-center font-medium text-principalhover">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                    <path
                                        d="M3.654 1.328a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.6 17.6 0 0 0 4.168 6.608 17.6 17.6 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.68.68 0 0 0-.58-.122l-2.19.547a1.75 1.75 0 0 1-1.657-.459L5.482 8.062a1.75 1.75 0 0 1-.46-1.657l.548-2.19a.68.68 0 0 0-.122-.58z" />
                                </svg>
                                Teléfono
                            </span>
                            {{ $row->data_invoice->phone }}

                            <span class="inline-flex items-center font-medium text-principalhover">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M10.125 2.25h-4.5c-.621 0-1.125.504-1.125 1.125v17.25c0 .621.504 1.125 1.125 1.125h12.75c.621 0 1.125-.504 1.125-1.125v-9M10.125 2.25h.375a9 9 0 0 1 9 9v.375M10.125 2.25A3.375 3.375 0 0 1 13.5 5.625v1.5c0 .621.504 1.125 1.125 1.125h1.5a3.375 3.375 0 0 1 3.375 3.375M9 15l2.25 2.25L15 12" />
                                </svg>
                                RFC
                            </span>
                            {{ $row->data_invoice->rfc }}

                            <span class="inline-flex items-center font-medium text-principalhover">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="1.5" stroke="currentColor" class="mr-2 size-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M8.25 6.75h12M8.25 12h12m-12 5.25h12M3.75 6.75h.007v.008H3.75V6.75Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0ZM3.75 12h.007v.008H3.75V12Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Zm-.375 5.25h.007v.008H3.75v-.008Zm.375 0a.375.375 0 1 1-.75 0 .375.375 0 0 1 .75 0Z" />
                                </svg>
                                CFDI
                            </span>
                            {{ $row->data_invoice->CFDICatalog->key }} -
                            {{ $row->data_invoice->CFDICatalog->description }}
                        </div>
                    </div>
                @endif
                <div x-data="{ open: false }" class="flex flex-col gap-1 p-4 border-b-2 border-gray-300">
                    <h3 @click="open = !open"
                        class="text-xl lg:text-2xl text-[#1d5394] font-semibold leading-none tracking-tight whitespace-nowrap cursor-pointer flex items-center justify-between">
                        Dirección
                        <svg :class="open ? 'rotate-180' : ''" class="w-5 h-5 transition-transform"
                            xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
                        </svg>
                    </h3>

                    <div x-show="open" x-collapse class="flex flex-col gap-2 text-sm">
                        <span class="inline-flex items-center font-medium text-principalhover">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                class="w-5 h-5 mr-2 bi bi-signpost" viewBox="0 0 16 16">
                                <path
                                    d="M7 1.414V4H2a1 1 0 0 0-1 1v4a1 1 0 0 0 1 1h5v6h2v-6h3.532a1 1 0 0 0 .768-.36l1.933-2.32a.5.5 0 0 0 0-.64L13.3 4.36a1 1 0 0 0-.768-.36H9V1.414a1 1 0 0 0-2 0M12.532 5l1.666 2-1.666 2H2V5z" />
                            </svg>
                            Calle principal
                        </span>
                        {{ $row->address_purchase->address->main_street }}

                        <span class="inline-flex items-center font-medium text-principalhover">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                class="w-5 h-5 mr-2 bi bi-sign-intersection-y" viewBox="0 0 16 16">
                                <path
                                    d="M10.493 5.197 8 7.483 5.507 5.197 4.493 6.303 7.25 8.83V12h1.5V8.83l2.757-2.527z" />
                                <path
                                    d="M9.05.435c-.58-.58-1.52-.58-2.1 0L.436 6.95c-.58.58-.58 1.519 0 2.098l6.516 6.516c.58.58 1.519.58 2.098 0l6.516-6.516c.58-.58.58-1.519 0-2.098zm-1.4.7a.495.495 0 0 1 .7 0l6.516 6.515a.495.495 0 0 1 0 .7L8.35 14.866a.495.495 0 0 1-.7 0L1.134 8.35a.495.495 0 0 1 0-.7L7.65 1.134Z" />
                            </svg>
                            Entre calles
                        </span>
                        {{ $row->address_purchase->address->between_streets }}

                        <span class="inline-flex items-center font-medium text-principalhover">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                class="w-5 h-5 mr-2 bi bi-mailbox2-flag" viewBox="0 0 16 16">
                                <path
                                    d="M10.5 8.5V3.707l.854-.853A.5.5 0 0 0 11.5 2.5v-2A.5.5 0 0 0 11 0H9.5a.5.5 0 0 0-.5.5v8z" />
                                <path
                                    d="M4 3h4v1H6.646A4 4 0 0 1 8 7v6h7V7a3 3 0 0 0-3-3V3a4 4 0 0 1 4 4v6a1 1 0 0 1-1 1H1a1 1 0 0 1-1-1V7a4 4 0 0 1 4-4m.585 4.157C4.836 7.264 5 7.334 5 7a1 1 0 0 0-2 0c0 .334.164.264.415.157C3.58 7.087 3.782 7 4 7s.42.086.585.157" />
                            </svg>
                            Código postal
                        </span>
                        {{ $row->address_purchase->address->zip_code }}

                        <span class="inline-flex items-center font-medium text-principalhover">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5 mr-2">
                                <path d="M20 10c0 6-8 12-8 12s-8-6-8-12a8 8 0 0 1 16 0Z"></path>
                                <circle cx="12" cy="10" r="3"></circle>
                            </svg>
                            Colonia
                        </span>
                        {{ $row->address_purchase->address->neighborhood }}

                        <span class="inline-flex items-center font-medium text-principalhover">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor"
                                class="w-5 h-5 mr-2 bi bi-house-check" viewBox="0 0 16 16">
                                <path
                                    d="M7.293 1.5a1 1 0 0 1 1.414 0L11 3.793V2.5a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 .5.5v3.293l2.354 2.353a.5.5 0 0 1-.708.708L8 2.207l-5 5V13.5a.5.5 0 0 0 .5.5h4a.5.5 0 0 1 0 1h-4A1.5 1.5 0 0 1 2 13.5V8.207l-.646.647a.5.5 0 1 1-.708-.708z" />
                                <path
                                    d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m1.679-4.493-1.335 2.226a.75.75 0 0 1-1.174.144l-.774-.773a.5.5 0 0 1 .708-.707l.547.547 1.17-1.951a.5.5 0 1 1 .858.514" />
                            </svg>
                            Referencias
                        </span>
                        {{ $row->address_purchase->address->reference }}
                    </div>

                </div>
                <p class="mt-4 text-lg font-semibold">Productos</p>
                @foreach ($row->product_price_purchases as $item)
                    <div class="flex w-full border-b-2 border-principal max-h-38 md:flex-row md:p-4 ">
                        <div class="w-20 h-auto md:w-20">
                            <img class="object-cover object-top w-full h-full "
                                src="{{ asset('storage/images/gallery/' . $item->product_price->product->image()) }}"
                                alt="{{ $item->product_price->product->image() }}">
                        </div>
                        <div class="flex flex-col justify-between w-full p-3">
                            <h4 class="text-sm font-semibold md:text-lg text-start lg:text-2xl ">
                                {{ is_null($item->product_price->product->name) ? '' : $item->product_price->product->name . ' - ' }}
                                {{ $item->product_price->product->category->name }}
                                ({{ $item->product_price->product->contents }}
                                {{ $item->product_price->product->measurement_unit->code }})
                            </h4>
                            <h4 class="text-sm font-light font-roboto md:text-lg text-start lg:text-xl ">
                                ${{ number_format($item->product_price->price, 2) }}
                            </h4>
                            <span class="text-xs font-bold text-gray-600 md:text-lg">
                                <span class="font-roboto">{{ $item->quantity }} unidad(es)</span>
                            </span>
                        </div>
                    </div>
                    {{-- PRODUCTO --}}
                @endforeach
                <div class="flex justify-between p-4 font-bold border-b border-gray-400">
                    <h4 class="text-xl font-bold text-gray-600 font-roboto">
                        Envío:
                        ${{ number_format($row->shipping, 2) }}
                    </h4>
                </div>
                <div class="flex flex-col lg:flex-row justify-between p-4 font-bold">
                    <h4 class="text-xl font-bold text-gray-600 font-roboto">
                        Total:
                        ${{ number_format($row->total(), 2) }}
                    </h4>
                    @if ($row->status_id == 24)
                        <p>Fecha limite de pago {{ date('d-m-Y', strtotime($row->payment_date)) }}</p>
                        <button wire:click="openModal({{ $row->id }})"
                            class="flex items-center justify-center gap-2 px-4 py-2 text-sm font-medium text-red-500 transition-colors duration-300 border-2 border-red-500 rounded-md w-fit group hover:bg-red-500 hover:text-white">
                            <i class="text-red-500 fa fa-trash group-hover:text-white"></i>
                            <span class="sr-only">Delete</span>
                            Cancelar Pedido
                        </button>

                        <a href="{{ route('checkout', $row->id) }}"
                            class="flex items-center gap-2 px-4 py-2 text-white transition-all duration-300 rounded-lg bg-principal hover:bg-principalhover">
                            <i class="fas fa-credit-card"></i>
                            Pagar
                        </a>
                    @endif
                </div>
            </div>
        @endforeach

        <div>
            @if ($modalOpen)
                <div id="popup-modal" tabindex="-1"
                    class="fixed top-0 left-0 z-50 flex items-center justify-center w-full h-full bg-black bg-opacity-50">
                    <div class="relative w-full max-w-md max-h-full p-4">
                        <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                            <button type="button" wire:click="closeModal"
                                class="absolute top-3 end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                                data-modal-hide="popup-modal">
                                <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                    fill="none" viewBox="0 0 14 14">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                </svg>
                                <span class="sr-only">Close modal</span>
                            </button>
                            <div class="p-4 text-center md:p-5">
                                <svg class="w-12 h-12 mx-auto mb-4 text-gray-400 dark:text-gray-200"
                                    aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none"
                                    viewBox="0 0 20 20">
                                    <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                        stroke-width="2" d="M10 11V6m0 8h.01M19 10a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                </svg>
                                <h3 class="mb-5 text-lg font-normal text-gray-500 dark:text-gray-400">
                                    ¿Estás seguro que deseas canelcar el pedido {{ $purchase->id }}?
                                </h3>
                                <button wire:click="deletePurchase()" data-modal-hide="popup-modal" type="button"
                                    class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-hidden focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center">
                                    Si, estoy seguro
                                </button>
                                <button data-modal-hide="popup-modal" wire:click="closeModal" type="button"
                                    class="py-2.5 px-5 ms-3 text-sm font-medium text-gray-900 focus:outline-hidden bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-principalhover focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">No,
                                    canelar</button>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    @else
        <h3 class="text-4xl font-bold text-center text-red-600">Sin compras actuales</h3>
    @endif
</main>
