<div class="px-4 py-14 md:px-6 2xl:px-20 2xl:container 2xl:mx-auto">
    <div class="flex flex-col justify-start space-y-2 item-start">
        <h1 class="text-3xl font-semibold leading-7 text-gray-800 dark:text-white lg:text-4xl lg:leading-9">Orden
            #{{ $purchase->id }}
        </h1>
        <p class="text-base font-medium leading-6 text-gray-600 dark:text-gray-300">
            {{ date('d-m-Y h:s A', strtotime($purchase->updated_at)) }}
        </p>
    </div>
    <div
        class="flex flex-col items-stretch w-full mt-10 space-y-4 xl:flex-row jusitfy-center xl:space-x-8 md:space-y-6 xl:space-y-0">
        <div class="flex flex-col items-start justify-start w-full space-y-4 md:space-y-6 xl:space-y-8">
            <div
                class="flex flex-col items-start justify-start w-full px-4 py-4 dark:bg-gray-800 bg-gray-50 md:py-6 md:p-6 xl:p-8">
                <p class="text-lg font-semibold leading-6 text-gray-800 md:text-xl dark:text-white xl:leading-5">
                    Carrito de compra</p>
                @if (count($products) > 0)
                    @foreach ($products as $item)
                        <div
                            class="flex flex-col w-full mt-4 md:mt-6 md:flex-row md:items-center md:space-x-6 xl:space-x-8">
                            <div class="flex-shrink-0 w-full pb-4 md:pb-8 md:w-40">
                                <img class="hidden w-full md:block"
                                    src="{{ asset('storage/images/gallery/' . $item->product_price->product->images->first()->path) }}"
                                    alt="dress" />
                                <img class="w-full h-60 object-contain md:hidden"
                                    src="{{ asset('storage/images/gallery/' . $item->product_price->product->images->first()->path) }}"
                                    alt="cafe" />
                            </div>
                            <div
                                class="flex flex-col w-full pb-8 space-y-4 border-b border-gray-200 md:flex-row md:space-y-0 md:items-center">
                                <div class="flex flex-col w-full space-y-4 md:space-y-8">
                                    <h3
                                        class="text-lg font-semibold leading-6 text-gray-800 sm:text-xl dark:text-white xl:text-2xl">
                                        {{ is_null($item->product_price->product->name) ? '' : $item->product_price->product->name }}
                                        <br>
                                        {{ $item->product_price->product->category->name }} <br>
                                        ({{ $item->product_price->product->contents }}
                                        {{ $item->product_price->product->measurement_unit->code }})
                                    </h3>
                                </div>
                                <div
                                    class="flex flex-col items-center justify-between w-full gap-4 lg:flex-row md:gap-8">
                                    <div class="flex items-center justify-center w-full space-x-4 xl:space-x-8">
                                        <p
                                            class="flex items-center justify-center px-2 py-1 text-base font-bold text-white transition-all rounded-lg bg-principalhover hover:bg-hoverPagination sm:text-lg xl:text-2xl">
                                            <button wire:click="editInventory({{ $item->id }}, 'minus')">
                                                <i class="fa fa-minus" aria-hidden="true"></i>
                                            </button>
                                        </p>
                                        <p class="mt-1 text-lg font-semibold text-gray-800 xl:text-xl">
                                            {{ $item->quantity }} unidad(es)
                                        </p>
                                        <p
                                            class="flex items-center justify-center px-2 py-1 text-base font-bold text-white transition-all rounded-lg bg-principalhover hover:bg-hoverPagination sm:text-lg xl:text-2xl">
                                            <button wire:click="editInventory({{ $item->id }}, 'plus')">
                                                <i class="fa fa-plus" aria-hidden="true"></i>
                                            </button>
                                        </p>
                                        @include('partials.error-inventory', [
                                            'input' => 'product-' . $item->id,
                                        ])
                                    </div>
                                    <div class="flex flex-col items-center w-full justify-evenly">
                                        <p class="text-gray-800 xl:text-lg">
                                            Precio unitario
                                        </p>
                                        <p class="font-semibold xl:text-lg">
                                            ${{ number_format($item->product_price->price, 2) }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="flex flex-col items-center lg:items-end w-full">
                            <p class="text-gray-800 text-xl xl:text-xl">
                                Total
                            </p>
                            <p class="font-semibold text-2xl xl:text-2xl">
                                ${{ number_format($item->product_price->price * $item->quantity, 2) }}
                            </p>
                        </div>
                        <h2 class="text-lg font-medium">
                            Total a pagar sin costo de envio <strong
                                class="text-xl text-principalhover">${{ number_format($total, 2) }}</strong>
                        </h2>
                    @endforeach
                @else
                    <h1>No hay productos</h1>
                @endif
            </div>

        </div>
        @if (count($products) > 0)
            <div
                class="flex flex-col items-center justify-between w-full px-4 py-6 bg-gray-50 dark:bg-gray-800 xl:w-96 md:items-start md:p-6 xl:p-8">
                <h3 class="text-xl font-semibold leading-5 text-gray-800 dark:text-white">Datos del Cliente</h3>
                <div
                    class="flex flex-col items-stretch justify-start w-full h-full md:flex-row xl:flex-col md:space-x-6 lg:space-x-8 xl:space-x-0">
                    <div class="flex flex-col items-start justify-start flex-shrink-0">
                        <div
                            class="flex items-center justify-center w-full py-8 space-x-4 border-b border-gray-200 md:justify-start">
                            <div class="flex flex-col items-start justify-start space-y-2">
                                <p class="text-base font-semibold leading-4 text-left text-gray-800 dark:text-white">
                                    {{ auth()->user()->person->first_name }}
                                    {{ auth()->user()->person->first_surname }}
                                    {{ auth()->user()->person->second_name }}
                                    {{ auth()->user()->person->second_surname }}
                                </p>
                                <p class="text-sm leading-5 text-gray-600 dark:text-gray-300">
                                    {{ $purchase->product_price_purchases->sum('quantity') }} Pedidos
                                </p>
                            </div>
                        </div>
                        <div class="flex flex-col items-stretch justify-between w-full mt-6 xl:h-full md:mt-0">
                            <div
                                class="flex flex-col items-center justify-center space-y-4 md:justify-start xl:flex-col md:space-x-6 lg:space-x-8 xl:space-x-0 xl:space-y-12 md:space-y-0 md:flex-row md:items-start">
                                <div
                                    class="flex flex-col items-center justify-center md:justify-start md:items-start xl:mt-8">
                                    <p
                                        class="text-base font-semibold leading-4 text-center text-gray-800 dark:text-white md:text-left">
                                        Dirección de envío</p>
                                    @if (count($addresses) > 0)
                                        <select id="addres_id" wire:model="address_id"
                                            class="w-full p-2 mt-4 border rounded-lg bg-gray-50 focus:ring-principal focus:border-principal">
                                            @foreach ($addresses as $address)
                                                <option value="{{ $address->id }}">Calle:
                                                    {{ $address->main_street }}, Entre Calles:
                                                    {{ $address->between_streets }}
                                                    C.P. {{ $address->zip_code }} Referencia:
                                                    {{ $address->reference }}
                                                    Colonia: {{ $address->neighborhood }}
                                                </option>
                                            @endforeach
                                        </select>
                                    @else
                                        <p class="mt-2 font-semibold text-gray-600">No tiene direcciones registre</p>
                                        <a href="{{ route('direcciones.index') }}"
                                            class="flex items-center gap-2 px-4 py-2 mt-4 font-semibold text-white transition-all duration-300 rounded-lg bg-principalhover hover:bg-hoverPagination">
                                            Agregue dirección
                                            <i class="fa fa-plus" aria-hidden="true"></i>
                                        </a>
                                    @endif
                                    @include('partials.input-error', ['input' => 'address_id'])
                                </div>

                            </div>
                        </div>
                        <div
                            class="flex flex-col items-center justify-center w-full py-4 space-x-4 text-gray-800 border-b border-gray-200 dark:text-white mt-2">
                            <p class="text-[#e6793f]">¿Desea facturar?</p>
                            <select id="invoice" wire:model.change="invoice"
                                class="bg-gray-50 border border-gray-300 dark:border text-gray-900 text-sm rounded-lg focus:ring-[#e6793f] focus:border-[#e6793f] block w-full p-2.5 mt-4 dark:focus:ring-[#e6793f] dark:focus:border-[#e6793f]">
                                <option value="0">NO</option>
                                <option value="1">SI</option>
                            </select>
                            @include('partials.input-error', ['input' => 'invoice'])
                            @if ($invoice == 1)
                                @if (!is_null($last_invoice))
                                    <p class="text-[#1d5394] text-xl px-4">Ultimo Registro de Factura</p>
                                @endif
                                <div class="flex flex-col my-4 w-full">
                                    <label for="full_name"
                                        class="block mb-2 font-semibold text-[#e6793f] ">Nombre:</label>
                                    <input type="text" id="full_name" name="full_name" wire:model="full_name"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-[#e6793f]">
                                    @include('partials.input-error', ['input' => 'full_name'])
                                </div>
                                <div class="mb-4 w-full">
                                    <label for="rfc" class="block mb-2 font-semibold text-[#e6793f] ">RFC:</label>
                                    <input type="text" id="rfc" name="rfc" wire:model="rfc"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-[#e6793f]">
                                    @include('partials.input-error', ['input' => 'rfc'])
                                </div>
                                <div class="mb-4 w-full">
                                    <label for="email"
                                        class="block mb-2 font-semibold text-[#e6793f] ">Email:</label>
                                    <input type="email" id="email" name="email" wire:model="email"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-[#e6793f]">
                                    @include('partials.input-error', ['input' => 'email'])
                                </div>
                                <div class="mb-4 w-full">
                                    <label for="phone"
                                        class="block mb-2 font-semibold text-[#e6793f] ">Teléfono:</label>
                                    <input type="email" id="phone" name="phone" wire:model="phone"
                                        class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-[#e6793f]">
                                    @include('partials.input-error', ['input' => 'phone'])
                                </div>
                                <div class="space-y-4">
                                    <p class="text-[#e6793f]">CFDI:</p>
                                    <select id="cfdi_catalogs_id" wire:model.change="cfdi_catalogs_id"
                                        class="bg-gray-50 border border-gray-300 dark:border  text-gray-900 text-sm rounded-lg focus:ring-[#e6793f] focus:border-[#e6793f] block w-full p-2.5    dark:focus:ring-[#e6793f] dark:focus:border-[#e6793f]">
                                        @foreach ($cfdi_catalogs as $item)
                                            <option value="{{ $item->id }}">{{ $item->key }} -
                                                {{ $item->description }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @include('partials.input-error', ['input' => 'cfdi_catalogs_id'])
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
    <div>
        @if ($modalOpen)
            <div id="popup-modal" tabindex="-1"
                class="fixed top-0 left-0 z-50 flex items-center justify-center w-full h-full bg-black bg-opacity-50">
                <div class="relative w-full max-w-md max-h-full p-4">
                    <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                        <button type="button" wire:click="closeModal"
                            class="absolute top-3 end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                            data-modal-hide="popup-modal">
                            <svg class="w-3 h-3" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 14 14">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                            </svg>
                            <span class="sr-only">Close modal</span>
                        </button>
                        <div class="p-4 text-center md:p-5">
                            <svg class="w-12 h-12 mx-auto mb-4 text-gray-400 dark:text-gray-200" aria-hidden="true"
                                xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20">
                                <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2" d="M10 11V6m0 8h.01M19 10a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                            </svg>
                            <h3 class="mb-5 text-lg font-normal text-gray-500 dark:text-gray-400">
                                ¿Desea confirmar la compra del pedido?
                            </h3>
                            <div class="flex justify-end gap-4">
                                <button data-modal-hide="popup-modal" wire:click="closeModal" type="button"
                                    class="py-2.5 px-5 ms-3 text-sm font-medium rounded-lg bg-red-600 hover:bg-red-800 text-white transition-all duration-300">
                                    No, cancelar
                                </button>
                                <form wire:submit="save">
                                    <button type="submit" data-modal-hide="popup-modal" type="button"
                                        class="text-white bg-green-600 cursor-pointer hover:bg-green-800 font-medium rounded-lg text-sm items-center px-5 py-2.5 text-center transition-all duration-300">
                                        Si, estoy seguro
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
    @if (count($products) > 0)
        <button wire:click="openModal"
            class="px-8 py-2 mt-10 text-xl font-semibold text-white transition-all duration-300 rounded-lg bg-principalhover hover:bg-black"
            type="button">Guardar</button>
        @include('partials.input-error', ['input' => 'error'])
    @endif
</div>
