<div>
    <section>
        <img src="{{ asset('storage/contacto/contacto.jpg') }}" alt="">
        <h1 class="p-5 text-5xl font-semibold text-center">CONTÁCTANOS</h1>
    </section>
    <section class="flex justify-center p-4 mb-10 text-white bg-contain bg-principal md:p-10 xl:items-center "
        style="background-image: url({{ asset('storage/index/pleca_tribal3.png') }});">
        <div class="grid gap-4 md:grid-cols-3 xl:mx-56 bg-[#241e1b] py-4">
            <div class="flex flex-col items-center justify-center">
                <img class="w-10 h-10 hover:scale-105"
                    src="{{ asset('storage/icons/' . $contact_details->where('id', 5)->first()->contactDataType->image) }}"
                    alt="facebook">
                <p class="text-xl font-bold">Dirección</p>
                <p class="text-lg text-center">{{ $contact_details->where('id', 5)->first()->resource }}</p>
            </div>
            <div class="flex flex-col items-center justify-center">
                <img class="w-10 h-10 hover:scale-105"
                    src="{{ asset('storage/icons/' . $contact_details->where('id', 4)->first()->contactDataType->image) }}"
                    alt="facebook">
                <p class="text-xl font-bold">Teléfono</p>
                <p class="text-lg">{{ $contact_details->where('id', 4)->first()->resource }}</p>
            </div>
            <div class="flex flex-col items-center justify-center">
                <img class="w-10 h-10 hover:scale-105"
                    src="{{ asset('storage/icons/' . $contact_details->where('id', 6)->first()->contactDataType->image) }}"
                    alt="facebook">
                <p class="text-xl font-bold">Correo electrónico</p>
                <p class="text-lg">{{ $contact_details->where('id', 6)->first()->resource }}</p>
            </div>
        </div>
    </section>
    <section class="container px-4 py-8 mx-auto">
        <div class="mx-auto overflow-hidden bg-white shadow-md max-w-7xl rounded-xl">
            <div class="md:flex">
                <div class="hidden md:w-1/2 md:block">
                    <div class="flex items-center justify-center h-full ">
                        <img src="{{ asset('storage/contacto/cafe.jpg') }}" alt="Imagen de contacto"
                            class="object-cover w-full h-full">
                    </div>
                </div>
                <div class="p-8 md:w-1/2">
                    <div class="mb-6 text-center">
                        <h1 class="text-5xl font-semibold text-gray-800">ESCRÍBENOS</h1>
                        <p class="mt-2 text-gray-600">Déjanos tu mensaje y te responderemos pronto</p>
                    </div>
                    <form class="space-y-6" wire:submit="save">
                        <div>
                            <label for="nombre" class="block text-sm font-medium text-gray-700">Nombre</label>
                            <input type="text" wire:model="full_name"
                                class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="Tu nombre completo">
                            @include('partials.input-error', ['input' => 'full_name'])
                        </div>
                        <div>
                            <label for="correo" class="block text-sm font-medium text-gray-700">Correo
                                electrónico</label>
                            <input type="email" wire:model="email"
                                class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="tu@correo.com">
                            @include('partials.input-error', ['input' => 'email'])
                        </div>
                        <div>
                            <label for="asunto" class="block text-sm font-medium text-gray-700">Asunto</label>
                            <input type="text" wire:model="subject"
                                class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="¿Sobre qué quieres contactarnos?">
                            @include('partials.input-error', ['input' => 'subject'])
                        </div>
                        <div>
                            <label for="mensaje" class="block text-sm font-medium text-gray-700">Mensaje</label>
                            <textarea wire:model="description" rows="4"
                                class="block w-full px-3 py-2 mt-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="Escribe tu mensaje aquí..."></textarea>
                            @include('partials.input-error', ['input' => 'description'])
                        </div>
                        <div>
                            <button type="submit"
                                class="flex justify-center w-full px-4 py-2 text-xl font-medium text-white transition-all duration-300 border border-transparent rounded-md shadow-sm bg-principal hover:bg-principalhover">
                                Enviar mensaje
                            </button>
                        </div>
                    </form>
                    @include('partials.confirmationModal', [
                        'title' => '¡Mensaje enviado!',
                        'message' => '¡Gracias por tu mensaje, te responderemos pronto!',
                    ])
                </div>
            </div>
        </div>
    </section>
</div>
