<div class="container max-w-7xl px-4 py-8 mx-auto">
    <a href="{{ route('users.index') }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div class="mx-auto overflow-hidden bg-white rounded-lg shadow-lg dark:bg-gray-700">
        <div class="px-8 py-6">
            <h2 class="mb-4 text-2xl font-bold text-gray-800 dark:text-white">Agregar Usuario</h2>
            <form wire:submit.prevent="store" class="space-y-4 flex flex-col #ffffw-full">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-10">
                    <div>
                        <div class="mb-4">
                            <label for="primer-nombre"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Primer
                                Nombre</label>
                            <input id="primer-nombre" type="text" placeholder="Primer Nombre" wire:model="first_name"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'first_name'])
                        </div>
                        <div class="mb-4">
                            <label for="segundo-nombre"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Segundo
                                Nombre</label>
                            <input id="segundo-nombre" type="text" placeholder="Segundo Nombre"
                                wire:model="second_name"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'second_name'])
                        </div>
                        <div class="mb-4">
                            <label for="primer-apellido"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Primer
                                Apellido</label>
                            <input id="primer-apellido" type="text" placeholder="Primer Apellido"
                                wire:model="first_surname"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'first_surname'])
                        </div>
                        <div class="mb-4">
                            <label for="segundo-apellido"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Segundo
                                Apellido</label>
                            <input id="segundo-apellido" type="text" placeholder="Segundo Apellido"
                                wire:model="second_surname"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'second_surname'])
                        </div>
                    </div>
                    <div>
                        <div class="mb-4">
                            <label for="telefono"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Teléfono</label>
                            <input id="telefono" type="text" placeholder="Teléfono" wire:model="phone"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'phone'])
                        </div>
                        <div class="mb-4">
                            <label for="fecha-nacimiento"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Fecha de
                                Nacimiento</label>
                            <input id="fecha-nacimiento" type="date" wire:model="birth_date"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'birth_date'])
                        </div>
                        <div class="mb-4">
                            <label for="email"
                                class="block mb-2 text-sm font-bold text-gray-700 dark:text-white">Correo
                                Electrónico</label>
                            <input id="email" type="email" placeholder="Correo Electrónico" wire:model="email"
                                class="w-full px-4 py-3 border border-gray-300 rounded-md shadow-xs dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent dark:bg-gray-800 dark:text-white">
                            @include('partials.input-error', ['input' => 'email'])
                        </div>
                        <div class="mb-4">
                            <label for="roleId"
                                class="block mb-2 text-sm font-medium text-gray-700 dark:text-white">Rol
                                @include('partials.required')</label>
                            <div class="relative">
                                <select id="roleId" wire:model.lazy="roleId"
                                    class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-md appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800 focus:outline-hidden focus:ring-2 focus:ring-orange-500 focus:border-transparent">
                                    @foreach ($roles as $role)
                                        <option value="{{ $role->id }}">{{ $role->name }}</option>
                                    @endforeach
                                </select>
                                <div
                                    class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                    <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                        <path d="M5 6l5 5 5-5z" />
                                    </svg>
                                </div>
                            </div>
                            @include('partials.input-error', ['input' => 'roleId'])
                        </div>
                    </div>
                </div>
                <div class="mt-7">
                    <div class="flex justify-between w-full space-x-2">
                        <button type="submit" id="submitBtn"
                            class="px-4 py-2 text-lg font-medium text-white bg-principalhover rounded-sm shadow-md hover:bg-hoverPagination transition-all duration-300">Guardar</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('js')
    <script>
        function deshabilitarBoton(event) {
            // Prevenir el comportamiento por defecto del formulario
            event.preventDefault();

            // Obtener el botón por su ID
            const boton = document.getElementById('submitBtn');

            // Deshabilitar el botón
            boton.disabled = true;

            // Cambiar el texto del botón (opcional)
            boton.textContent = "Enviando...";

            // Cambiar el color de fondo del botón deshabilitado (opcional)
            boton.classList.add('bg-gray-500', 'cursor-not-allowed');
            boton.classList.remove('bg-orange-400', 'hover:bg-orange-600');


        }
    </script>
@endpush
