<div class="min-h-screen">
    <a href="{{ route('users.index') }}">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Regresar</p>
        </button>
    </a>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h2 class="mb-4 text-2xl font-bold text-gray-800 dark:text-white">Editar usuario</h2>
        <form wire:submit.prevent="save"
            class="w-full bg-white rounded-sm shadow-md dark:bg-gray-700 mt-4 lg:mt-8 p-5">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-10">
                <div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="primer-nombre">
                            Primer Nombre
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="primer-nombre" type="text" placeholder="Primer Nombre" wire:model="first_name">
                        @include('partials.input-error', ['input' => 'first_name'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="segundo-nombre">
                            Segundo Nombre
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="segundo-nombre" type="text" placeholder="Segundo Nombre" wire:model="second_name">
                        @include('partials.input-error', ['input' => 'second_name'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="primer-apellido">
                            Primer Apellido
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="primer-apellido" type="text" placeholder="Primer Apellido"
                            wire:model="first_surname">
                        @include('partials.input-error', ['input' => 'first_surname'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="segundo-apellido">
                            Segundo Apellido
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="segundo-apellido" type="text" placeholder="Segundo Apellido"
                            wire:model="second_surname">
                        @include('partials.input-error', ['input' => 'second_surname'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="telefono">
                            Teléfono
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="telefono" type="text" placeholder="Teléfono" wire:model="phone">
                        @include('partials.input-error', ['input' => 'phone'])
                    </div>
                </div>
                <div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="fecha-nacimiento">
                            Fecha de Nacimiento
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="fecha-nacimiento" type="date" wire:model="birth_date">
                        @include('partials.input-error', ['input' => 'birth_date'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="email">
                            Correo Electrónico
                        </label>
                        <input
                            class="w-full px-4 py-3 border border-gray-300 rounded-md dark:border-gray-600 focus:outline-hidden focus:ring-2 focus:ring-blue-500 focus:border-transparent dark:bg-gray-800 dark:text-white"
                            id="email" type="email" placeholder="correo electronico" wire:model="email">
                        @include('partials.input-error', ['input' => 'email'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="roleId">
                            Rol
                        </label>
                        <div class="relative">
                            <select wire:model.lazy="roleId"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="roleId">
                                @foreach ($roles as $role)
                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'roleId'])
                    </div>
                    <div class="mb-4">
                        <label class="block mb-2 font-bold text-gray-700 dark:text-white" for="status_id">
                            Estado
                        </label>
                        <div class="relative">
                            <select wire:model.lazy="status_id"
                                class="block w-full px-4 py-3 mb-2 text-sm placeholder-gray-500 bg-white border rounded-sm appearance-none dark:text-gray-400 dark:border-gray-900 dark:bg-gray-800"
                                id="status_id">
                                @foreach ($status as $row)
                                    <option value="{{ $row->id }}">{{ $row->name }}</option>
                                @endforeach
                            </select>
                            <div
                                class="absolute inset-y-0 right-0 flex items-center px-2 text-gray-500 pointer-events-none">
                                <svg class="w-4 h-4 fill-current" viewBox="0 0 20 20">
                                    <path d="M5 6l5 5 5-5z" />
                                </svg>
                            </div>
                        </div>
                        @include('partials.input-error', ['input' => 'status_id'])
                    </div>
                </div>
            </div>

            <div class="flex items-center justify-between">
                <button type="submit"
                    class="px-4 py-2 font-bold text-white rounded-sm bg-principal hover:bg-principalhover focus:outline-hidden focus:shadow-outline">
                    Guardar
                </button>
            </div>
        </form>
    </div>

</div>
