@if (session('server'))
    <div x-data="{ showAlert: true }" x-show="showAlert" x-init="setTimeout(() => showAlert = false, 5000)"
        class="absolute z-50 flex items-center justify-between px-6 py-4 text-white bg-red-500 rounded-lg shadow-lg top-28 lg:top-36 lg:right-4 mx-4 lg:mx-0">
        <span>{{ session('server') }}</span>
        <button @click="showAlert = false" class="lg:ml-4 text-white hover:text-gray-200">
            &times;
        </button>
    </div>
@endif

@if (session('success'))
    <div x-data="{ showAlert: true }" x-show="showAlert" x-init="setTimeout(() => showAlert = false, 5000)"
        class="absolute z-50 flex items-center justify-between px-6 py-4 text-white bg-green-500 rounded-lg shadow-lg top-28 lg:top-36 lg:right-4 mx-4 lg:mx-0">
        <span>{{ session('success') }}</span>
        <button @click="showAlert = false" class="lg:ml-4 text-white hover:text-gray-200">
            &times;
        </button>
    </div>
@endif

@error('sucess')
    <section class="flex items-center bg-gray-50 font-poppins dark:bg-gray-800 ">
        <div class="justify-center flex-1 max-w-4xl px-4 py-4 mx-auto lg:py-10 ">
            <div x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform translate-y-2"
                class="relative p-6 text-green-700 bg-green-100 border-b-2 border-green-500 dark:border-green-400 dark:bg-gray-800"
                role="alert">
                <div class="flex">
                    <div class="py-1">
                        <i class="w-6 h-6 mr-4 text-green-500 dark:text-green-400 bi bi-check-circle-fill"></i>
                    </div>
                    <div>
                        <p class="mb-1 text-lg font-bold dark:text-gray-300">Error </p>
                        <p class="text-sm dark:text-gray-400">{{ $message }}
                        </p>
                    </div>
                </div>

            </div>
        </div>
    </section>
@enderror

@error('server')
    <section class="flex items-center bg-gray-50 font-poppins dark:bg-gray-800 ">
        <div class="justify-center flex-1 max-w-4xl px-4 py-4 mx-auto lg:py-10 ">
            <div x-transition:enter="transition ease-out duration-300"
                x-transition:enter-start="opacity-0 transform translate-y-2"
                x-transition:enter-end="opacity-100 transform translate-y-0"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform translate-y-0"
                x-transition:leave-end="opacity-0 transform translate-y-2"
                class="relative p-6 text-red-700 bg-red-100 border-b-2 border-red-500 dark:border-red-400 dark:bg-gray-800"
                role="alert">
                <div class="flex">
                    <div class="py-1">
                        <i class="w-6 h-6 mr-4 text-red-500 dark:text-red-400 bi bi-check-circle-fill"></i>
                    </div>
                    <div>
                        <p class="mb-1 text-lg font-bold dark:text-gray-300">Error </p>
                        <p class="text-sm dark:text-gray-400">{{ $message }}
                        </p>
                    </div>
                </div>

            </div>
        </div>
    </section>
@enderror
