<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/', 'DashBoardController@home')->name('home');

Route::get('login', 'AuthController@login')->name('login');
Route::get('forget-password', 'AuthController@showForgetPasswordForm')->name('forget.password');
Route::get('reset-password/{token}', 'AuthController@showResetPasswordForm')->name('reset.password');

Route::get('quienes-somos', 'DashBoardController@about')->name('about');
Route::get('productos', 'DashBoardController@products')->name('products');
Route::get('cafe-con-causa', 'DashBoardController@cafeConCausa')->name('cafeConCausa');
Route::get('contacto', 'DashBoardController@contact')->name('contacto');
Route::get('producto/{product}', 'DashBoardController@product')->name('product');
Route::get('registro', 'AuthController@customerRegistration')->name('customer.registration');

Route::get('purchase-response/{id}','DashBoardController@purchaseResponse')->name('purchase-response');
// Route::get('codigo',function (){
//     return view('welcome');
// });

Route::middleware(['auth', 'status'])->group(function () {
    Route::post('logout', 'AuthController@logout')->name('logout');
    Route::get('mis-datos', 'AuthController@myInformation')->name('my.information');
    Route::get('resumen-compra', 'DashBoardController@summary')->name('summary');
    Route::get('checkout/{id}', 'DashBoardController@checkout')->name('checkout');

    Route::prefix('admin')->middleware(['role:1'])->group(function () {
            Route::get('dashboard', 'AuthController@dashboard')->name('dashboard');
            Route::resource('users', 'Admin\UserController')->except(['destroy', 'update', 'store']);
            Route::resource('configuration', 'Admin\ConfigurationController')->except(['destroy', 'update', 'store', 'show', 'edit']);
            

            Route::resource('products', 'Admin\ProductController')->except(['destroy', 'update', 'store', 'show']);
            Route::resource('inventories', 'Admin\InventoryController')->except(['destroy', 'update', 'store', 'show', 'index', 'create']);
            Route::resource('purchases', 'Admin\PurchaseController')->except(['destroy', 'update', 'store', 'show']);
        });
    Route::middleware(['role:2'])->group(function () {
        Route::resource('compras', 'Client\ShoppingController')->except(['destroy', 'update', 'store', 'create', 'edit', 'show']);
        Route::resource('direcciones', 'Client\AddressController')->except(['destroy', 'update', 'store', 'create', 'show']);
        // Route::get('detalle-compra/{shopping}','Client\ShoppingController@show')->name('shopping.details');
    });
});
