<div class="flex justify-center items-center">
    <img src="<?php echo e(asset('storage/index/marco1.jpg')); ?>" alt="image register"
        class="hidden md:block w-1/2 h-screen object-cover">
    <a href="/login" class="absolute top-36 left-5 z-20">
        <button type="button"
            class="relative w-48 font-sans text-xl font-semibold text-center text-black bg-white rounded-2xl h-14 group">
            <div
                class="bg-principal rounded-xl h-12 w-1/4 flex items-center justify-center absolute left-1 top-[4px] group-hover:w-[184px] z-10 duration-500">
                <svg width="25px" height="25px" viewBox="0 0 1024 1024" xmlns="http://www.w3.org/2000/svg">
                    <path fill="#ffff" d="M224 480h640a32 32 0 1 1 0 64H224a32 32 0 0 1 0-64z"></path>
                    <path fill="#ffff"
                        d="m237.248 512 265.408 265.344a32 32 0 0 1-45.312 45.312l-288-288a32 32 0 0 1 0-45.312l288-288a32 32 0 1 1 45.312 45.312L237.248 512z">
                    </path>
                </svg>
            </div>
            <p class="translate-x-2">Inicio</p>
        </button>
    </a>
    <div class="flex flex-col w-full lg:bg-white md:w-1/2">
        <div class="flex flex-col justify-center mt-12 px-5 sm:px-10 lg:px-20 pt-8 w-full">
            <p class="text-3xl font-bold text-center text-slate lg:text-gray-700 md:text-left md:leading-tight">Crea
                tu cuenta</p>
            <p class="mt-6 font-medium text-center text-slate lg:text-gray-700 md:text-left">
                ¿Ya tienes una cuenta?
                <a href="<?php echo e($url); ?>"
                    class="font-semibold underline text-slate lg:text-blue-700 whitespace-nowrap">Inicia sesión</a>
            </p>
            <form class="grid grid-cols-1 lg:grid-cols-2 gap-4 pt-3 md:pt-8" wire:submit="save">
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="primer-nombre">
                        Primer Nombre
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="primer-nombre" type="text" placeholder="Primer Nombre" wire:model="first_name">
                    <?php echo $__env->make('partials.input-error', ['input' => 'first_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="segundo-nombre">
                        Segundo Nombre
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="segundo-nombre" type="text" placeholder="Segundo Nombre" wire:model="second_name">
                    <?php echo $__env->make('partials.input-error', ['input' => 'second_name'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="primer-apellido">
                        Primer Apellido
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="primer-apellido" type="text" placeholder="Primer Apellido" wire:model="first_surname">
                    <?php echo $__env->make('partials.input-error', ['input' => 'first_surname'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="segundo-apellido">
                        Segundo Apellido
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="segundo-apellido" type="text" placeholder="Segundo Apellido" wire:model="second_surname">
                    <?php echo $__env->make('partials.input-error', ['input' => 'second_surname'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="telefono">
                        Teléfono
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="telefono" type="text" placeholder="Teléfono" wire:model="phone">
                    <?php echo $__env->make('partials.input-error', ['input' => 'phone'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="fecha-nacimiento">
                        Fecha de Nacimiento
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight text-gray-700 border rounded-sm shadow-sm appearance-none focus:outline-hidden focus:shadow-outline"
                        id="fecha-nacimiento" type="date" wire:model="birth_date">
                    <?php echo $__env->make('partials.input-error', ['input' => 'birth_date'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="mb-4">
                    <label class="block mb-2 text-sm font-bold text-slate lg:text-gray-700" for="segundo-apellido">
                        Correo Electrónico
                    </label>
                    <input
                        class="w-full px-3 py-2 leading-tight border rounded-sm shadow-sm appearance-none text-slate-800 lg:text-gray-700 focus:outline-hidden focus:shadow-outline"
                        id="email" type="email" placeholder="correo electronico" wire:model="email">
                    <?php echo $__env->make('partials.input-error', ['input' => 'email'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="flex justify-end lg:col-span-2">
                    <button
                        class="px-4 py-2 mb-10 font-bold text-white rounded-sm bg-principal hover:bg-principalhover focus:outline-hidden focus:shadow-outline"
                        type="submit">
                        Guardar
                    </button>
                </div>
                <div wire:loading wire:target="save"
                    class="fixed inset-0 z-50 flex items-center justify-center bg-black/50 backdrop-blur-sm">
                    <div class="h-screen flex justify-center items-center">
                        <div class="flex flex-col items-center justify-center bg-black/50 p-6 rounded-lg">
                            <i class="fas fa-spinner fa-spin text-4xl text-blue-600 mb-4"></i>
                            <p class="text-sm text-gray-100">Creando cuenta</p>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/auth/customer-registration.blade.php ENDPATH**/ ?>