<div>
    <main class="mx-auto mt-5 antialiased dark:bg-gray-900 md:mt-10 max-w-7xl">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white md:text-4xl">Carrito de compras</h2>
        <div class="flex flex-col gap-6 px-4 mx-auto mt-5 md:flex-row max-w-(--breakpoint-2xl) 2xl:px-0">
            <div
                class="flex flex-col border-2 border-principal/50 rounded-lg shadow-lg md:w-1/2 gap-3 p-5 overflow-y-auto max-h-[30rem] hover:shadow-principalhover transition-all duration-500">
                <!--[if BLOCK]><![endif]--><?php if(count($products) > 0): ?>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex items-center justify-center w-full h-full max-h-38 md:flex-row md:p-0">
                            <img class="object-contain object-top h-32 lg:h-40 lg:w-1/4"
                                src="<?php echo e(asset('storage/images/gallery/' . $item->product_price->product->image())); ?>"
                                alt="<?php echo e($item->product_price->product->image()); ?>">
                            <div class="flex flex-col justify-between w-full gap-2 p-3">
                                <h4 class="text-sm font-semibold md:text-lg text-start lg:text-2xl ">
                                    <?php echo e($item->product_price->product->name); ?></h4>
                                <h4 class="text-sm font-light font-roboto md:text-lg text-start lg:text-xl ">
                                    $<?php echo e(number_format($item->product_price->price, 2)); ?></h4>
                                <span class="inline-flex text-xs font-bold text-gray-800 md:text-lg">
                                    <div class="flex items-center gap-2 text-xs md:text-lg">
                                        <span class="font-roboto"><?php echo e($item->quantity); ?></span> unidad(es)
                                    </div>
                                </span>
                                
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    <h1>No hay productos</h1>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="md:w-1/2 ">
                <div
                    class="max-w-xl mx-auto space-y-6 transition-all duration-500 border-2 rounded-lg shadow-lg border-principal/50 md:mt-6 lg:mt-0 lg:w-full hover:shadow-principalhover">
                    <div
                        class="p-4 space-y-4 bg-white border border-gray-200 rounded-lg shadow-xs dark:border-gray-700 dark:bg-gray-800 sm:p-6">
                        <p class="text-xl font-semibold text-gray-900 dark:text-white">Resumen de compra</p>
                        <div class="space-y-4">
                            <div class="space-y-2">
                                <dl class="flex items-center justify-between gap-4">
                                    <dt class="text-base font-bold text-gray-500 dark:text-gray-400">Precio a pagar</dt>
                                    <dd class="text-base font-medium text-gray-900 font-roboto dark:text-white">
                                        $<?php echo e(number_format($clothes, 2)); ?></dd>
                                </dl>
                                
                                <dl class="flex items-center justify-between gap-4">
                                    <dt class="text-base font-bold text-gray-500 dark:text-gray-400">Envío</dt>
                                    <dd class="text-base font-medium text-gray-900 font-roboto dark:text-white">
                                        $<?php echo e(number_format($shipping, 2)); ?></dd>
                                </dl>
                                
                            </div>
                            <dl
                                class="flex items-center justify-between gap-4 pt-2 border-t border-gray-200 dark:border-gray-700">
                                <dt class="text-base font-bold text-gray-900 dark:text-white">Total</dt>
                                <dd class="text-base font-bold text-gray-900 font-roboto dark:text-white">
                                    $<?php echo e(number_format($total, 2)); ?></dd>
                            </dl>
                        </div>
                        <div class="font-bold font-roboto" id="wallet_container"></div>
                        <input type="hidden" id="deviceId">
                    </div>
                </div>
            </div>

            
            <div id="customModalApro" tabindex="-1"
                class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 flex justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <!-- Overlay negro semitransparente -->
                <div class="fixed inset-0 bg-black bg-opacity-50"></div>

                <!-- Contenedor del modal -->
                <div class="relative w-full max-w-md max-h-full p-4">
                    <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                        <!-- Botón para cerrar el modal -->
                        
                        <!-- Contenido del modal -->
                        <div class="flex flex-col p-4 text-center md:p-5">
                            <!-- Icono de éxito -->
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor"
                                class="mx-auto mb-4 text-green-500 animate-bounce size-20 dark:text-gray-200">
                                <path class="" stroke-linecap="round" stroke-linejoin="round"
                                    d="M9 12.75 11.25 15 15 9.75M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                            </svg>
                            <!-- Título del modal -->
                            <h3 class="mb-5 text-xl font-normal text-green-500 capitalize dark:text-gray-400">PAGO
                                APROBADO</h3>
                            <!-- Mensaje de agradecimiento -->
                            <span>¡Gracias por tu compra!</span>
                            <!-- Botón para continuar -->
                            <a href="<?php echo e(route('compras.index')); ?>"
                                class="text-white justify-center bg-principal hover:bg-principalhover focus:ring-4 focus:outline-none focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mt-4">
                                Ir a mis compras
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="customModalRejec" tabindex="-1"
                class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 flex justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <!-- Overlay negro semitransparente -->
                <div class="fixed inset-0 bg-black bg-opacity-50"></div>

                <!-- Contenedor del modal -->
                <div class="relative w-full max-w-md max-h-full p-4">
                    <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                        <!-- Botón para cerrar el modal -->
                        
                        <!-- Contenido del modal -->
                        <div class="flex flex-col p-4 text-center md:p-5">
                            <!-- Icono de éxito -->

                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor"
                                class="mx-auto mb-4 text-red-500 animate-bounce size-20 dark:text-gray-200">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m9.75 9.75 4.5 4.5m0-4.5-4.5 4.5M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                            </svg>
                            <!-- Título del modal -->
                            <h3 class="mb-5 text-xl font-normal text-red-500 capitalize dark:text-gray-400">PAGO
                                RECHAZADO</h3>
                            <!-- Mensaje de agradecimiento -->
                            <span>Por favor, inténtelo de nuevo</span>
                            <!-- Botón para continuar -->
                            <a href=""
                                class="text-white justify-center bg-principal hover:bg-principalhover focus:ring-4 focus:outline-none focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mt-4">
                                Reintentar
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="customModalPending" tabindex="-1"
                class="hidden overflow-y-auto overflow-x-hidden fixed top-0 right-0 left-0 z-50 flex justify-center items-center w-full md:inset-0 h-[calc(100%-1rem)] max-h-full">
                <!-- Overlay negro semitransparente -->
                <div class="fixed inset-0 bg-black bg-opacity-50"></div>

                <!-- Contenedor del modal -->
                <div class="relative w-full max-w-md max-h-full p-4">
                    <div class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                        <!-- Botón para cerrar el modal -->
                        
                        <!-- Contenido del modal -->
                        <div class="flex flex-col p-4 text-center md:p-5">
                            <!-- Icono de éxito -->


                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="1.5" stroke="currentColor"
                                class="mx-auto mb-4 text-blue-500 animate-bounce size-20 dark:text-gray-200">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="m11.25 11.25.041-.02a.75.75 0 0 1 1.063.852l-.708 2.836a.75.75 0 0 0 1.063.853l.041-.021M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9-3.75h.008v.008H12V8.25Z" />
                            </svg>
                            <!-- Título del modal -->
                            <h3 class="mb-5 text-xl font-normal text-blue-500 capitalize dark:text-gray-400">PAGO
                                PENDIENTE</h3>
                            <!-- Mensaje de agradecimiento -->
                            <span>Por favor, inténtelo de nuevo</span>
                            <!-- Botón para continuar -->
                            <a href="<?php echo e(route('compras.index')); ?>"
                                class="text-white justify-center bg-principal hover:bg-principalhover focus:ring-4 focus:outline-none focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center mt-4">
                                Por favor, revise sus compras hasta que se apruebe su pago
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
<?php $__env->startPush('js'); ?>
    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script src="https://www.mercadopago.com/v2/security.js" view="checkout" output="deviceId"></script>
    
    <script>
        const token = "<?php echo e(config('app.public_key')); ?>";
        const preference_id = "<?php echo e($preference['id']); ?>";
        const mp = new MercadoPago(token, {
            locale: 'es-MX'
        });

        mp.bricks().create("wallet", "wallet_container", {
            initialization: {
                preferenceId: preference_id,
                //redirectMode: 'modal'
            },
            customization: {
                texts: {
                    action: 'buy',
                    valueProp: 'security_details'
                }
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/dashboard/checkout.blade.php ENDPATH**/ ?>