<div class="w-full max-w-6xl px-4 py-8 mx-auto sm:px-6 lg:px-8">
    <div class="mb-6">
        <h1 class="text-3xl font-bold">Administrar mis direcciones de envío</h1>
    </div>
    <div class="grid grid-cols-1 gap-6 md:grid-cols-2">
        <div class="transition-shadow duration-300 border rounded-lg shadow-lg bg-card text-card-foreground hover:shadow-2xl"
            data-v0-t="card">
            <div class="flex flex-col space-y-1.5 p-6">
                <h3 class="text-2xl font-semibold leading-none tracking-tight whitespace-nowrap">Mis direcciones</h3>
            </div>
            <div class="p-6">
                <div class="space-y-4">
                    <!--[if BLOCK]><![endif]--><?php if(count($address) > 0): ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $address; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="grid grid-cols-[40px_1fr] border-b-2 pb-4 border-principal items-center gap-4">
                                <div
                                    class="flex items-center justify-center w-10 h-10 rounded-full bg-primary text-primary-foreground">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                        stroke-linecap="round" stroke-linejoin="round" class="w-5 h-5">
                                        <path d="m3 9 9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                        <polyline points="9 22 9 12 15 12 15 22"></polyline>
                                    </svg>
                                </div>
                                <div>
                                    <p class="font-medium"><?php echo e($item->main_street . ', Col. ' . $item->neighborhood . ', C.P. ' . $item->zip_code.', ' .$item->between_streets); ?></p>
                                    <p class="text-muted-foreground">
                                        Referencias: <span class="ml-2"><?php echo e($item->reference); ?></span>
                                    </p>
                                </div>
                                <div class="flex gap-2 ml-auto">
                                    <div class="flex flex-col">
                                        <a href="<?php echo e(route('direcciones.edit', $item->id)); ?>"
                                            class="inline-flex items-center justify-center w-10 h-10 text-sm font-medium transition-all group duration-300 border rounded-md whitespace-nowrap ring-offset-background focus-visible:outline-hidden focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 hover:text-white hover:bg-yellow-400">
                                            <i class="fa fa-pencil-alt text-yellow-400 group-hover:text-white"></i>
                                            <span class="sr-only">Edit</span>
                                        </a>
                                    </div>
                                    <div class="flex flex-col">
                                        <button wire:click="openModal"
                                            class="inline-flex items-center justify-center w-10 h-10 group text-sm font-medium text-red-500 transition-colors duration-300 border rounded-md whitespace-nowrap ring-offset-background focus-visible:outline-hidden focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 disabled:pointer-events-none disabled:opacity-50 border-input bg-background hover:bg-red-500 hover:text-white">
                                            <i class="fa fa-trash text-red-500 group-hover:text-white"></i>
                                            <span class="sr-only">Delete</span>
                                        </button>
                                        <div>
                                            <!--[if BLOCK]><![endif]--><?php if($modalOpen): ?>
                                                <div id="popup-modal" tabindex="-1"
                                                    class="fixed top-0 left-0 z-50 flex items-center justify-center w-full h-full bg-black bg-opacity-50">
                                                    <div class="relative w-full max-w-md max-h-full p-4">
                                                        <div
                                                            class="relative bg-white rounded-lg shadow-sm dark:bg-gray-700">
                                                            <button type="button" wire:click="closeModal"
                                                                class="absolute top-3 end-2.5 text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm w-8 h-8 ms-auto inline-flex justify-center items-center dark:hover:bg-gray-600 dark:hover:text-white"
                                                                data-modal-hide="popup-modal">
                                                                <svg class="w-3 h-3" aria-hidden="true"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 14 14">
                                                                    <path stroke="currentColor" stroke-linecap="round"
                                                                        stroke-linejoin="round" stroke-width="2"
                                                                        d="m1 1 6 6m0 0 6 6M7 7l6-6M7 7l-6 6" />
                                                                </svg>
                                                                <span class="sr-only">Close modal</span>
                                                            </button>
                                                            <div class="p-4 text-center md:p-5">
                                                                <svg class="w-12 h-12 mx-auto mb-4 text-gray-400 dark:text-gray-200"
                                                                    aria-hidden="true"
                                                                    xmlns="http://www.w3.org/2000/svg" fill="none"
                                                                    viewBox="0 0 20 20">
                                                                    <path stroke="currentColor" stroke-linecap="round"
                                                                        stroke-linejoin="round" stroke-width="2"
                                                                        d="M10 11V6m0 8h.01M19 10a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" />
                                                                </svg>
                                                                <h3
                                                                    class="mb-5 text-lg font-normal text-gray-500 dark:text-gray-400">
                                                                    ¿Estás seguro que deseas
                                                                    eliminar esta dirección?</h3>
                                                                <button
                                                                    wire:click="deleteAddress('<?php echo e($item->id); ?>')"
                                                                    data-modal-hide="popup-modal" type="button"
                                                                    class="text-white bg-red-600 hover:bg-red-800 focus:ring-4 focus:outline-hidden focus:ring-red-300 dark:focus:ring-red-800 font-medium rounded-lg text-sm inline-flex items-center px-5 py-2.5 text-center">
                                                                    Si, estoy seguro
                                                                </button>
                                                                <button data-modal-hide="popup-modal"
                                                                    wire:click="closeModal" type="button"
                                                                    class="py-2.5 px-5 ms-3 text-sm font-medium text-gray-900 focus:outline-hidden bg-white rounded-lg border border-gray-200 hover:bg-gray-100 hover:text-principalhover focus:z-10 focus:ring-4 focus:ring-gray-100 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">No,
                                                                    canelar</button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php else: ?>
                        <div class="flex flex-col items-center justify-center gap-4 p-6 text-center">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                stroke-linejoin="round" class="w-12 h-12 text-primary">
                                <path d="M20 10c0 6-8 12-8 12s-8-6-8-12a8 8 0 0 1 16 0Z"></path>
                                <circle cx="12" cy="10" r="3"></circle>
                            </svg>
                            <div class="space-y-2">
                                <h2 class="text-2xl font-bold">No se encontraron direcciones</h2>
                                <p class="text-muted-foreground">No tiene direcciones registradas, registre una en el
                                    formulario que está a continuación</p>
                            </div>
                        </div>

                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <?php echo e($address); ?>

            </div>
        </div>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('client.address.create');

$__html = app('livewire')->mount($__name, $__params, 'lw-3217963131-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    </div>
</div>
<?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/client/address/index.blade.php ENDPATH**/ ?>