<div class="mx-5 my-5 lg:mx-36 lg:my-20">

    <section class="grid gap-10 my-5 md:grid-cols-2">
        <div class="flex items-center justify-center ">
            <img src="<?php echo e(asset('storage/images/gallery/' . $product->images->first()->path)); ?>" alt="imagen prooducto">
        </div>
        <div class="flex flex-col">
            <h3 class="text-3xl font-bold">
                <?php echo e(is_null($product->name) ? '' : $product->name . ' - '); ?>

                <?php echo e($product->category->name); ?>

                (<?php echo e($product->contents); ?>

                <?php echo e($product->measurement_unit->code); ?>)</h3>
            
            <h4 class="text-2xl font-bold">Precio: $<?php echo e(number_format($product->price->price, 2)); ?> m.n.</h4>
            
            <div class="flex items-center mt-5 mb-5">
                <img src="<?php echo e(asset('storage/productos/icono_envio.png')); ?>" alt="">
                <p class="ml-1 text-xs font-normal ">*EL ENVIÓ SE COTIZA AL MOMENTO DE SEGÚN PESO Y DESTINO | ENVIÓ A
                    TODO MÉXICO</p>
            </div>

            <div class="flex flex-col items-center justify-center gap-4 lg:flex-row">
                <!--[if BLOCK]><![endif]--><?php if(auth()->check()): ?>
                    <!--[if BLOCK]><![endif]--><?php if($inventory > 0): ?>
                        <div class="w-full">
                            <form wire:submit="save"
                                class="flex flex-col items-center justify-center gap-5 lg:flex-row">
                                
                                <div class="relative flex items-center max-w-[11rem]">
                                    
                                    
                                    <?php if(auth()->user()->role_id != 1): ?>
                                        <input type="number" id="quantity" name="quantity" min="1"
                                            max="5" wire:model="quantity" wire:click="chargeQuantity()"
                                            class="w-20 text-lg font-bold text-center border-gray-300 rounded-md shadow-xs font-roboto focus:border-indigo-300 focus:ring-3 focus:ring-indigo-200 focus:ring-opacity-50">
                                        <?php echo $__env->make('partials.counter-error', ['input' => 'error'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php echo $__env->make('partials.counter-success', ['input' => 'success'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    
                                    
                                </div>
                                <?php if(auth()->user()->role_id != 1): ?>
                                    <button type="submit"
                                        class="w-full px-4 py-2 text-lg font-semibold text-white transition-all duration-300 rounded-lg bg-principal hover:bg-principalhover">
                                        AGREGAR A SU PEDIDO
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </form>
                            <h4 class="mt-3 text-xl">Productos disponibles: <strong><?php echo e($inventory); ?></strong></h4>
                        </div>
                    <?php else: ?>
                        <div class="flex flex-col w-full">
                            <h2 class="text-2xl font-bold">Producto no disponible</h2>
                            <h4 class="text-principalhover">Por el momento este producto no posee suficiente
                                inventario, intente más tarde</h4>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php else: ?>
                    <a href="<?php echo e(route('customer.registration')); ?>"
                        class="w-full px-4 py-2 text-lg font-semibold text-center text-white transition-all duration-300 rounded-lg bg-principal hover:bg-principalhover">Regístrate
                        para Comprar</a>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <div class="w-full py-3 mt-4 border-t-4 border-b-4">
                <h5 class="mb-3 text-xl font-normal text-principal">FICHA TÉCNICA</h5>
                <div class="flex flex-col gap-1">
                    <div class="flex items-center mr-6">
                        
                        <span class="text-base"><strong>Presentación:</strong> <?php echo e($product->introduction); ?></span>
                    </div>
                    <div class="flex items-center">
                        
                        <span class="text-base"><strong>Origen:</strong> <?php echo e($product->origin); ?></span>
                    </div>
                    <div class="flex items-center mr-6">
                        
                        <span class="text-base"><strong>Tueste:</strong> <?php echo e($product->roasting); ?></span>
                    </div>
                    
                </div>
            </div>
            <h5 class="mt-3 text-xl font-normal text-principal">DESCRIPCIÓN</h5>
            <p class="font-semibold"><?php echo e($product->description); ?></p>
        </div>
    </section>
    <section>
        <h4 class="mx-5 text-2xl font-bold uppercase ">También te puede interesar</h4>
        <section class="grid grid-cols-1 gap-3 lg:gap-8 md:grid-cols-3 ">
            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('product', $item->id)); ?>" class="flex flex-col items-center justify-center">
                    <img class="h-[60%] lg:h-auto"
                        src="<?php echo e(asset('storage/images/gallery/' . $item->images->first()->path)); ?>" alt="producto">
                    <h4 class="text-2xl font-semibold text-center lg:text-start">
                        <?php echo e(is_null($item->name) ? '' : $item->name . ' - '); ?>

                        <?php echo e($item->category->name); ?>

                        (<?php echo e($item->contents); ?>

                        <?php echo e($item->measurement_unit->code); ?>)
                    </h4>
                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            
        </section>
    </section>
</div>
<?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/dashboard/product.blade.php ENDPATH**/ ?>