<div class="min-h-screen mb-4 rounded-lg shadow-xl dark:-gray-600 h-96">
    <div wire:loading class="flex items-center justify-center w-full h-full">
        <div class="flex items-center justify-center space-x-1 text-sm text-gray-700">
            <svg fill='none' class="w-6 h-6 animate-spin" viewBox="0 0 32 32" xmlns='http://www.w3.org/2000/svg'>
                <path clip-rule='evenodd'
                    d='M15.165 8.53a.5.5 0 01-.404.58A7 7 0 1023 16a.5.5 0 011 0 8 8 0 11-9.416-7.874.5.5 0 01.58.404z'
                    fill='currentColor' fill-rule='evenodd' />
            </svg>
            <div>Cargando ...</div>
        </div>
    </div>
    <section wire:loading.remove class="p-3 antialiased bg-gray-50 dark:bg-gray-900 sm:p-5">
        <div class="mx-auto ">
            <div class="flex items-end w-full">
                <form class="max-w-sm ">
                    <label for="countries"
                        class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">Filtros</label>
                    <select wire:model="status_id" wire:change="searchElement()"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $status; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>
                </form>
            </div>
            <?php echo $__env->make('partials.input-error', ['input' => 'status_selected'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="relative overflow-hidden bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left text-gray-500 dark:text-gray-400">
                        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
                            <tr>
                                <th scope="col" class="px-4 py-4">ID</th>
                                <th scope="col" class="px-4 py-4">Cliente</th>
                                <th scope="col" class="px-4 py-3">Fecha de Compra</th>
                                <th scope="col" class="px-4 py-3">Factura</th>
                                <th scope="col" class="px-4 py-3">Estatus</th>
                                <th scope="col" class="px-2 py-2">
                                    <span class="sr-only">Actions</span>
                                    <span class="">Acciones</span>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $orderes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="border-b dark:border-gray-700">
                                    <th scope="row"
                                        class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                        <?php echo e($row->id); ?></th>
                                    <th scope="row"
                                        class="px-4 py-3 font-medium text-gray-900 whitespace-nowrap dark:text-white">
                                        <?php echo e($row->user->person->first_name. ' ' . $row->user->person->first_surname); ?>

                                    </th>
                                    <td class="px-4 py-3 max-w-[12rem] truncate">
                                        <?php echo e(date('d/m/y h:i A', strtotime($row->created_at))); ?>

                                    </td>
                                    <td class="px-4 py-3 max-w-[12rem] truncate">
                                        <?php echo e($row->invoice == 1 ? 'SI' : 'NO'); ?>

                                    </td>
                                    <td class="px-4 py-3">
                                        
                                        <?php echo e($row->status->name); ?>

                                    </td>
                                    <td>
                                        <div class="p-4">
                                            <a href="<?php echo e(route('purchases.edit', $row->id)); ?>"
                                                class="inline-flex items-center hover:text-blue-500 gap-2 transition-all duration-300">
                                                <i class="fas fa-eye text-lg"></i>
                                                Ver detalles
                                            </a>
                                            
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </section>
    <?php echo e($orderes->links()); ?>

</div>
<?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/admin/purchase/index.blade.php ENDPATH**/ ?>