<section class="mt-5">
    <div
        class="flex flex-row w-full justify-between items-center mb-6 border-b border-gray-200 dark:border-gray-700 pb-4">
        <?php echo $__env->make('partials.backButton', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="mt-5 w-full">
        <div class=" bg-white rounded-lg overflow-hidden">
            <div class="p-5 lg:p-10">
                <h2 class="mb-2 text-2xl font-semibold text-gray-800 dark:text-white">Cantidad de Productos del
                    Inventario</h2>
                
                <form wire:submit="save">
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Nombre del
                        Producto: <?php echo e($product->name); ?></label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Descripción:
                        <?php echo e($product->description); ?></label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Cantidad:
                        <?php echo e($product->quantity($product->id)); ?></label>
                    <label for="code" class="block mb-2 font-semibold text-gray-700 dark:text-white">Precio
                        Actual: $<?php echo e($product->price->price); ?></label>

                    <div class="flex flex-col md:flex-row w-full my-6 gap-5 lg:gap-10">
                        <div class="w-full md:w-1/2">
                            <label for="inventory_type_id"
                                class="block font-medium text-gray-900 dark:text-white mb-2">Tipo de Acción</label>
                            <select id="inventory_type_id" wire:model="inventory_type_id"
                                class="bg-gray-50 border border-gray-300 dark:border  text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $inventoryTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <?php echo $__env->make('partials.input-error', ['input' => 'inventory_type_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="w-full md:w-1/2">
                            <label for="quantity"
                                class="block font-semibold text-gray-700 dark:text-white mb-2">Cantidad de
                                Productos</label>
                            <input type="number" id="quantity" name="quantity" min="1" wire:model="quantity"
                                required
                                class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-hidden focus:border-blue-500">
                            <?php echo $__env->make('partials.input-error', ['input' => 'quantity'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                    </div>
                    

                    <div class="flex items-center justify-between gap-3 mt-10">
                        <button type="submit" id="submitBtn"
                            class="px-4 py-2 font-bold text-white rounded-md transition-all duration-300 bg-principal hover:bg-principalhover focus:outline-hidden focus:shadow-outline">
                            Guardar
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
    </div>
</section>

<?php $__env->startPush('js'); ?>
    <script>
        function deshabilitarBoton(event) {
            event.preventDefault();

            const boton = document.getElementById('submitBtn');

            boton.disabled = true;

            boton.textContent = "Enviando...";

            boton.classList.add('bg-gray-500', 'cursor-not-allowed');
            boton.classList.remove('bg-principal', 'hover:bg-orange-600');
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\laragon\www\web-finca-monte-verde-v1\resources\views/livewire/admin/inventory/edit.blade.php ENDPATH**/ ?>