/** @type {import('tailwindcss').Config} */
module.exports = {
    //  darkMode: 'media',
    content: [
        "./resources/**/*.blade.php",
        "./resources/**/*.js",
        "./resources/**/*.vue",
        "./node_modules/flowbite/**/*.js",
    ],
    theme: {
        extend: {
            fontFamily: {
                sarabun: ["Sarabun", "sans-serif"],
                roboto: ["roboto", "sans-serif"],
                aleo: ["Aleo", "sans-serif"],
            },
            colors: {
                accent: "#1f2937",
                principal: "#0c0a09",
                principalhover: "#5a902e",
                hoverPagination: "#3d611f",
                secondary: "#1c1917",
                slate: "#475569",
            },
            keyframes: {
                "fade-in": {
                    "0%": { opacity: "0", transform: "scale(0.95)" },
                    "100%": { opacity: "1", transform: "scale(1)" },
                },
            },
            animation: {
                "fade-in": "fade-in 0.3s ease-out forwards",
            },
            screens: {
                xs: "370px",
                // => @media (min-width: 320px) { ... }
                "3xl": "1920px",
            },
        },
    },
    plugins: [require("flowbite/plugin")],
};
